.TH gperl @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
gperl \- execute Perl commands in
.I groff
documents
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright 2014-2020 Free Software Foundation, Inc.
.\"
.\" This file is part of gperl.
.\"
.\" gperl is distributed with groff, the GNU roff typesetting system.
.\"
.\" groff is free software; you can redistribute it and/or modify it
.\" under the terms of the GNU General Public License as published by
.\" the Free Software Foundation, either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" groff is distributed in the hope that it will be useful, but WITHOUT
.\" ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
.\" or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
.\" License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see
.\" <https://www.gnu.org/licenses/>.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_gperl_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY gperl
.RI [ file\~ .\|.\|.]
.YS
.
.
.P
.SY gperl
.B \-h
.YS
.
.SY gperl
.B \-\-help
.YS
.
.
.P
.SY gperl
.B \-v
.YS
.
.SY gperl
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
This is a preprocessor for
.MR groff @MAN1EXT@ .
.
It allows the use of
.MR perl 7
code in
.MR groff @MAN7EXT@
files.
.
The result of a
.I Perl part
can be stored in groff
.I strings
or
.I numerical registers
based on the arguments at a final line of a
.IR "Perl part" .
.
.
.P
If no operands are given,
or if
.I file
is
.RB \[lq] \- \[rq],
.I gperl
reads the standard input stream.
.
A double-dash argument
.RB (\[lq] \-\- \[rq])
causes all subsequent arguments to be interpreted as
.I file
operands,
even if their names start with a dash.
.
.B \-h
and
.B \-\-help
display a usage message,
whereas
.B \-v
and
.B \%\-\-version
display version information;
all exit afterward.
.
.
.\" ====================================================================
.SH "Perl regions"
.\" ====================================================================
.
.I Perl
parts in
.I groff files
are enclosed by two
.B .Perl
requests with different arguments, a
.I starting
and an
.I ending
command.
.
.
.\" ====================================================================
.SS "Starting Perl mode"
.\" ====================================================================
.
The starting
.I Perl request
can either be without arguments, or by a request that has the term
.B start
as its only argument.
.RS
.IP \(bu
.B .Perl
.IP \(bu
.B .Perl start
.RE
.
.
.\" ====================================================================
.SS "Ending Perl mode without storage"
.\" ====================================================================
.
A
.B .Perl
command line with an argument different from
.B start
finishes a running
.IR "Perl part" .
.
Of course, it would be reasonable to add the argument
.BR stop ;
that's possible, but not necessary.
.
.RS
.IP \(bu
.B .Perl stop
.IP \(bu
.BI .Perl " other_than_start"
.RE
.
The argument
.I other_than_start
can additionally be used as a
.I groff
string variable name for storage \(em see next section.
.
.
.\" ====================================================================
.SS "Ending Perl mode with storage"
.\" ====================================================================
.
A useful feature of
.I gperl
is to store one or more results from the
.IR "Perl mode" .
.
.
.P
The output of a
.I Perl part
can be got with backticks
.BR \[ga]...\[ga] .
.
.
.P
This program collects all printing to STDOUT (normal standard output)
by the Perl
.B print
program.
.
This pseudo-printing output can have several lines, due to printed
line breaks with
.BR \(rsn .
.
By that, the output of a Perl run should be stored into a Perl array,
with a single line for each array member.
.
.
.P
This Perl array output can be stored by
.I gperl
in either
.TP
.I groff strings
by creating a groff command
.B .ds
.
.TP
.I groff register
by creating a groff command
.B .rn
.
.
.P
The storage modes can be determined by arguments of a final stopping
.B .Perl
command.
.
Each argument
.B .ds
changes the mode into
.I groff string
and
.B .nr
changes the mode into
.I groff register
for all following output parts.
.
.
.br
.ne 2v
.P
By default, all output is saved as strings, so
.B .ds
is not really needed before the first
.B .nr
command.
.
That suits to
.MR groff @MAN7EXT@ ,
because every output can be saved as
.I groff
string, but the registers can be very restrictive.
.
.
.P
In
.IR "string mode" ,
.I gperl
generates a
.I groff string
storage line
.RS
.EX
.BI .ds " var_name content"
.EE
.RE
.
In
.I register mode
the following groff command is generated
.RS
.EX
.BI .nr " var_name content"
.EE
.RE
.
.
.P
We present argument collections in the following.
.
You can add as first argument for all
.BR stop .
.
We omit this additional element.
.
.
.P
.TP
.BI ".Perl .ds " var_name
This will store 1 output line into the groff string named
.I var_name
by the automatically created command
.RS
.RS
.EX
.BI .ds " var_name output"
.EE
.RE
.RE
.
.
.TP
.BI .Perl " var_name"
If
.I var_name
is different from
.B start
this is equivalent to the former command, because the string mode is
string with
.B .ds
command.
default.
.
.
.TP
.BI .Perl " var_name1 var_name2"
This will store 2 output lines into groff string names
.I var_name1
and
.IR var_name2 ,
because the default mode
.B .ds
is active, such that no
.B .ds
argument is needed.
.
Of course, this is equivalent to
.RS
.RS
.EX
.BI ".Perl .ds " "var_name1 var_name2"
.EE
.RE
and
.RS
.EX
.BI ".Perl .ds " "var_name1 " ".ds" " var_name2"
.EE
.RE
.RE
.
.
.TP
.BI ".Perl .nr" " var_name1 varname2"
stores both variables as register variables.
.
.I gperl
generates
.RS
.EX
.BI .nr " var_name1 output_line1"
.BI .nr " var_name2 output_line2"
.EE
.RE
.
.
.TP
.BI ".Perl .nr " var_name1 " .ds " var_name2
stores the 1st argument as
.I register
and the second as
.I string
by
.RS
.EX
.BI .nr " var_name1 output_line1"
.BI .ds " var_name2 output_line2"
.EE
.RE
.
.
.\" ====================================================================
.SH Example
.\" ====================================================================
.
A possible
.I Perl part
in a
.I roff file
could look like that:
.RS
.EX
before
\&.Perl start
my $result = \[aq]some data\[aq];
print $result;
\&.Perl stop .ds string_var
after
.EE
.RE
.
.
.P
This stores the result
.B \(rqsome data\(rq
into the
.I roff string
called
.BR string_var ,
such that the following line is printed:
.RS
.EX
\&.ds string_var some data
.EE
.RE
by
.I gperl
as food for the coming
.I groff
run.
.
.
.P
A
.I Perl part
with several outputs is:
.RS
.EX
\&.Perl start
print \(rqfirst\(rsn\(rq;
print \(rqsecond line\(rsn\(rq;
print \(rq3\(rsn\(rq;
\&.Perl var1 var2 .nr var3
.EE
.RE
.
This stores 3 printed lines into 3
.I groff
strings.
.BR var1 , var2 , var3 .
.
So the following
.I groff
command lines are created:
.RS
.EX
\&.ds var1 first
\&.ds var2 second line
\&.nr var3 3
.EE
.RE
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.I gperl
was written by
.MT groff\-bernd\:.warken\-72@\:web\:.de
Bernd Warken
.ME .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.P
Man pages related to
.I groff
are
.MR groff @MAN1EXT@ ,
.MR groff @MAN7EXT@ ,
and
.MR grog @MAN1EXT@ .
.
.
.P
Documents related to
.I Perl
are
.MR perl 1 ,
.MR perl 7 .
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_gperl_1_man_C]
.do rr *groff_gperl_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
